/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* -----------------------------------------------------------------------
 * File: observer.h
 * Author: Christoph Schmidt 3.11.97
 * Purpose: This file contains the function prototypes for the observer
 * control functions.
 * ----------------------------------------------------------------------- */

#ifndef OBSERVER_H_INCLUDED
#define OBSERVER_H_INCLUDED

#include <obsdefs.h>


#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------
 * PCI Observer Functions
 * -----------------------------------------------------------------------
 */

CLI b_errtype EXPORT BestObsMaskSet(              /* @omset */
    b_handletype  handle,
    b_obsruletype obsrule,                        /* @rule */
    b_int32       value                           /* @val  */
    );


CLI b_errtype EXPORT BestObsMaskGet(              /* @omget */
    b_handletype  handle,
    b_obsruletype obsrule,                        /* @rule */
    b_int32 *     value                           /* #RETURN "Value= %i\n" */
    );


b_errtype EXPORT BestObsMaskRegSet (
    b_handletype  handle,
    b_int32       maskstat,
    b_int32       maskstat2,
    b_int32       value
    );

b_errtype EXPORT BestObsMaskRegGet (
    b_handletype  handle,
    b_int32      *maskstat,
    b_int32      *maskstat2
    );


CLI b_errtype EXPORT BestObsPropDefaultSet(       /* @oprpdefset */
    b_handletype handle
    );


CLI b_errtype EXPORT BestObsStatusGet(            /* @osget */
    b_handletype    handle,
    b_obsstatustype obsstatus,                    /* @stat */
    b_int32 *       value                         /* #RETURN "Value= %08lx\\h\n" */
    );


CLI b_errtype EXPORT BestObsStatusClear(          /* @osclear */
    b_handletype handle
    );


CLI b_errtype EXPORT BestObsRuleErrTypeGet(              /* @osruleget */
                                b_handletype   handle,
				b_int32       bitposition,  /* @pos */
				b_obsruletype *obsrule  /* #RETURN "%s" */
				);

b_errtype EXPORT BestObsRuleGet(             
				b_int32       bitposition,
				b_obsruletype *obsrule  
				);


CLI b_errtype EXPORT BestObsErrStringGet(         /* @oestrget */
					 b_handletype   handle,
					 b_int32        bitposition,  /* @pos */
					 b_charptrtype  *errortext    /* #RETURN "%s\n" */
    );


b_errtype EXPORT BestObsBitPositionFind (
  			b_handletype	handle,
			b_int32ptr	errstat,
			b_int32ptr	errstat2,
			b_int32ptr	bitposition
			);


CLI b_errtype EXPORT BestObsErrResultGet (	  /* @oeresultget */
  			b_handletype	handle,
			b_int32     	errstat   /* @errstat */,
			b_int32		errstat2  /* @errstat2 */,
			b_ccharptrtype *errortext /* #RETURN "%s\n" */
			);


CLI b_errtype EXPORT BestObsRun(                  /* @orun */
    b_handletype handle
    );


CLI b_errtype EXPORT BestObsStop(                 /* @ostop */
    b_handletype handle
    );


#ifdef __cplusplus
}
#endif

#endif

